# cPanel Deployment Quick Start Guide

## Step 1: Upload Files

1. **Download all project files** from this workspace
2. **Create a new folder** in your cPanel File Manager (e.g., `menu-system`)
3. **Upload the following files** to your folder:
   - All source code files (server/, client/, shared/ folders)
   - `database_export.sql`
   - `package-production.json` (rename to `package.json`)
   - `production.js`
   - `.env.example` (copy to `.env` and configure)

## Step 2: Database Setup

1. **Create PostgreSQL Database** in cPanel
   - Go to PostgreSQL Databases
   - Create database: `menu_system_db`
   - Create user and assign to database
   - Note the credentials

2. **Import Database**
   - Open phpPgAdmin or database interface
   - Execute the `database_export.sql` file
   - Verify tables are created

## Step 3: Environment Configuration

Edit the `.env` file with your database credentials:
```
DATABASE_URL=postgresql://username:password@localhost:5432/menu_system_db
JWT_SECRET=your-random-secret-key-minimum-32-characters
NODE_ENV=production
PORT=5000
```

## Step 4: Node.js App Setup

1. **Go to Node.js in cPanel**
2. **Create Node.js App** with:
   - Node.js version: 18.x or higher
   - Application mode: Production
   - Application root: `/menu-system` (your folder)
   - Application startup file: `production.js`
   - Application URL: your domain/subdomain

3. **Install Dependencies**
   - Click "Run NPM Install"
   - Wait for completion

4. **Add Environment Variables** in Node.js settings:
   - `DATABASE_URL`: your PostgreSQL connection string
   - `JWT_SECRET`: a secure random string
   - `NODE_ENV`: production

5. **Start Application**
   - Click "Restart App"

## Step 5: Access Your Application

- **Customer Menu**: `https://yourdomain.com`
- **Admin Panel**: `https://yourdomain.com/admin`
- **Login**: username: `admin`, password: `admin123`

## Important Notes

- Change the default admin password immediately
- Enable SSL/HTTPS for security
- Regular database backups recommended
- Test the Arabic language toggle and time-based categories

## Troubleshooting

If the app doesn't start:
1. Check Node.js error logs in cPanel
2. Verify database connection in .env file
3. Ensure all dependencies installed correctly
4. Check file permissions (755 for directories, 644 for files)

## Support

The system includes:
- Time-based menu availability
- Bilingual English/Arabic support
- Admin panel for menu management
- Customer feedback collection
- Template customization
- User management