import { useState } from "react";
import { Button } from "@/components/ui/button";
import { LanguageToggle } from "@/components/ui/language-toggle";
import { MenuGrid } from "@/components/menu/menu-grid";
import { FeedbackForm } from "@/components/menu/feedback-form";
import { useLanguage } from "@/hooks/use-language";
import { Shield } from "lucide-react";

export default function CustomerMenu() {
  const { t } = useLanguage();

  const handleAdminLogin = () => {
    window.location.href = "/admin";
  };

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Header */}
      <header className="bg-white shadow-sm border-b">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex justify-between items-center h-16">
            <div className="flex items-center">
              <h1 className="text-2xl font-bold text-gray-800">
                {t("Delicious Bites", "الطعم اللذيذ")}
              </h1>
            </div>
            <div className="flex items-center space-x-4">
              <LanguageToggle />
              <Button 
                onClick={handleAdminLogin}
                className="bg-orange-600 hover:bg-orange-700 text-white"
              >
                <Shield className="h-4 w-4 mr-2" />
                {t("Admin", "المدير")}
              </Button>
            </div>
          </div>
        </div>
      </header>

      {/* Menu Content */}
      <MenuGrid />

      {/* Feedback Form */}
      <FeedbackForm />
    </div>
  );
}
