# Menu Management System - cPanel Deployment Package

## Package Contents

This zip file contains everything needed to deploy the bilingual menu management system on your cPanel hosting.

### Essential Files
- `database_export.sql` - Complete database schema with sample data
- `server-production.js` - Production-optimized server file
- `package-production.json` - Production dependencies (rename to package.json)
- `.env.example` - Environment configuration template
- `DEPLOYMENT_GUIDE.md` - Detailed deployment instructions
- `cpanel-setup.md` - Quick setup guide

### Source Code
- `client/` - React frontend application
- `server/` - Express.js backend API
- `shared/` - Shared types and database schema
- Configuration files (tailwind.config.ts, vite.config.ts, etc.)

## Quick Start

1. **Create PostgreSQL database** in cPanel
2. **Import database_export.sql** to set up tables
3. **Upload all files** to your hosting directory
4. **Configure .env** with your database credentials
5. **Set up Node.js app** in cPanel pointing to server-production.js
6. **Install dependencies** and start the application

## System Features

- **Bilingual Support**: English/Arabic with RTL layout
- **Time-Based Menus**: Categories automatically show/hide based on time
- **Admin Panel**: Complete menu and user management
- **Customer Interface**: Browse menus and submit feedback
- **Template System**: Multiple layout options
- **Currency**: KWD format with 3 decimal places

## Default Access

- **Customer Menu**: Your domain
- **Admin Panel**: yourdomain.com/admin
- **Login**: username: `admin`, password: `admin123`

## Support

Refer to DEPLOYMENT_GUIDE.md for detailed instructions and troubleshooting.